//3.RADIATION PATTERN OF SQUARE ARRAY ANTENNA FOR FOUR ELEMENTS (RECTANGULAR PLOT) 
//OS-Windows 7
//Scilab 6.0.2
// Antenna Arrays
//Course Instructor Name: Dr. V. A. Sankar Ponnapalli
//Institute Name: Sreyas Institute of Engineering & Technology
clc;
clear;
close;
af=0; // af-Array Factor
thio=0; //STEERING ANGLE
phio=0; // STEERING ANGLE
phi=%pi/2; // Elevation Angle
thi=-%pi:%pi/10000:%pi; // Azimuthal Angle
r=0.5//Radius
k=2*%pi // Wave Number
    for n=1:4 // NUMBER OF ANTENNA ELEMENTS
        phin=(n-1).*(2.*%pi/4) // Antenna Element Position
        a=(exp(%i.*k.*r.*(((sin(thi)*cos(phi-phin)))-(sin(thio)*cos(phio-phin)))));
        af=a+af;
    end
af1=abs(af); //af1- Array Factor
af1=af1/max(max((af1)));
SAA=20.*log10(af1); // SAA-SQUARE ARRAY ANTENNA
plot((thi*57.3),(SAA));
xlabel('THETA');
ylabel('ARRAY FACTOR (dB)')
title('RADIATION PATTERN OF SQUARE ARRAY ANTENNA');
//h=gca();
//h.data_bounds=[-90,-80;90,0];

// DESCRIPTION OF THE FIGURE: 
//*************************ARRAY FACTOR PROPERTIES***************************
//                            Half Power Beam Width (HPBW): 43.4 (In degrees) 
//                            Side Lobe Level (SLL)       : -0.47 dB
//                            Side Lobe Level Angle (SLLA): 171.1 (In degrees) 
